/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tools.ant;

import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.PrintStream;
import java.io.Writer;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Stack;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import org.apache.tools.ant.BuildEvent;
import org.apache.tools.ant.BuildException;
import org.apache.tools.ant.BuildLogger;
import org.apache.tools.ant.DefaultLogger;
import org.apache.tools.ant.Target;
import org.apache.tools.ant.Task;
import org.apache.tools.ant.UnknownElement;
import org.apache.tools.ant.util.DOMElementWriter;
import org.apache.tools.ant.util.StringUtils;
import org.w3c.dom.CDATASection;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
public class XmlLogger
implements BuildLogger {
    private static DocumentBuilder builder = XmlLogger.getDocumentBuilder();
    private static final String BUILD_TAG = "build";
    private static final String TARGET_TAG = "target";
    private static final String TASK_TAG = "task";
    private static final String MESSAGE_TAG = "message";
    private static final String NAME_ATTR = "name";
    private static final String TIME_ATTR = "time";
    private static final String PRIORITY_ATTR = "priority";
    private static final String LOCATION_ATTR = "location";
    private static final String ERROR_ATTR = "error";
    private static final String STACKTRACE_TAG = "stacktrace";
    private int msgOutputLevel;
    private PrintStream outStream;
    private Document doc;
    private Hashtable tasks;
    private Hashtable targets;
    private Hashtable threadStacks;
    private TimedElement buildElement;

    private static final DocumentBuilder getDocumentBuilder() {
        try {
            return DocumentBuilderFactory.newInstance().newDocumentBuilder();
        }
        catch (Exception exception) {
            throw new ExceptionInInitializerError(exception);
        }
    }

    public void buildStarted(BuildEvent buildEvent) {
        this.buildElement = new TimedElement();
        this.buildElement.startTime = System.currentTimeMillis();
        this.buildElement.element = this.doc.createElement(BUILD_TAG);
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void buildFinished(BuildEvent buildEvent) {
        block13: {
            Object object;
            Object object2;
            Object object3;
            long l = System.currentTimeMillis() - this.buildElement.startTime;
            this.buildElement.element.setAttribute(TIME_ATTR, DefaultLogger.formatTime(l));
            if (buildEvent.getException() != null) {
                this.buildElement.element.setAttribute(ERROR_ATTR, buildEvent.getException().toString());
                object3 = buildEvent.getException();
                object2 = this.doc.createCDATASection(StringUtils.getStackTrace((Throwable)object3));
                object = this.doc.createElement(STACKTRACE_TAG);
                object.appendChild((Node)object2);
                this.buildElement.element.appendChild((Node)object);
            }
            if ((object3 = buildEvent.getProject().getProperty("XmlLogger.file")) == null) {
                object3 = "log.xml";
            }
            if ((object2 = buildEvent.getProject().getProperty("ant.XmlLogger.stylesheet.uri")) == null) {
                object2 = "log.xsl";
            }
            object = null;
            try {
                try {
                    OutputStream outputStream = this.outStream;
                    if (outputStream == null) {
                        outputStream = new FileOutputStream((String)object3);
                    }
                    object = new OutputStreamWriter(outputStream, "UTF8");
                    ((Writer)object).write("<?xml version=\"1.0\" encoding=\"UTF-8\"?>\n");
                    if (((String)object2).length() > 0) {
                        ((Writer)object).write("<?xml-stylesheet type=\"text/xsl\" href=\"" + (String)object2 + "\"?>\n\n");
                    }
                    new DOMElementWriter().write(this.buildElement.element, (Writer)object, 0, "\t");
                    ((Writer)object).flush();
                }
                catch (IOException iOException) {
                    throw new BuildException("Unable to write log file", iOException);
                }
            }
            catch (Throwable throwable) {
                Object var8_9 = null;
                if (object == null) throw throwable;
                try {
                    ((Writer)object).close();
                    throw throwable;
                }
                catch (IOException iOException) {}
                throw throwable;
            }
            {
                Object var8_10 = null;
                if (object == null) break block13;
            }
            try {}
            catch (IOException iOException) {}
            ((Writer)object).close();
        }
        this.buildElement = null;
    }

    private final Stack getStack() {
        Stack stack = (Stack)this.threadStacks.get(Thread.currentThread());
        if (stack == null) {
            stack = new Stack();
            this.threadStacks.put(Thread.currentThread(), stack);
        }
        return stack;
    }

    public void targetStarted(BuildEvent buildEvent) {
        Target target = buildEvent.getTarget();
        TimedElement timedElement = new TimedElement();
        timedElement.startTime = System.currentTimeMillis();
        timedElement.element = this.doc.createElement(TARGET_TAG);
        timedElement.element.setAttribute(NAME_ATTR, target.getName());
        this.targets.put(target, timedElement);
        this.getStack().push(timedElement);
    }

    public void targetFinished(BuildEvent buildEvent) {
        Target target = buildEvent.getTarget();
        TimedElement timedElement = (TimedElement)this.targets.get(target);
        if (timedElement != null) {
            long l = System.currentTimeMillis() - timedElement.startTime;
            timedElement.element.setAttribute(TIME_ATTR, DefaultLogger.formatTime(l));
            TimedElement timedElement2 = null;
            Stack stack = this.getStack();
            if (!stack.empty()) {
                TimedElement timedElement3 = (TimedElement)stack.pop();
                if (timedElement3 != timedElement) {
                    throw new RuntimeException("Mismatch - popped element = " + timedElement3 + " finished target element = " + timedElement);
                }
                if (!stack.empty()) {
                    timedElement2 = (TimedElement)stack.peek();
                }
            }
            if (timedElement2 == null) {
                this.buildElement.element.appendChild(timedElement.element);
            } else {
                timedElement2.element.appendChild(timedElement.element);
            }
        }
        this.targets.remove(target);
    }

    public void taskStarted(BuildEvent buildEvent) {
        TimedElement timedElement = new TimedElement();
        timedElement.startTime = System.currentTimeMillis();
        timedElement.element = this.doc.createElement(TASK_TAG);
        Task task = buildEvent.getTask();
        String string = buildEvent.getTask().getTaskName();
        timedElement.element.setAttribute(NAME_ATTR, string);
        timedElement.element.setAttribute(LOCATION_ATTR, buildEvent.getTask().getLocation().toString());
        this.tasks.put(task, timedElement);
        this.getStack().push(timedElement);
    }

    public void taskFinished(BuildEvent buildEvent) {
        Task task = buildEvent.getTask();
        TimedElement timedElement = (TimedElement)this.tasks.get(task);
        if (timedElement != null) {
            TimedElement timedElement2;
            long l = System.currentTimeMillis() - timedElement.startTime;
            timedElement.element.setAttribute(TIME_ATTR, DefaultLogger.formatTime(l));
            Target target = task.getOwningTarget();
            TimedElement timedElement3 = null;
            if (target != null) {
                timedElement3 = (TimedElement)this.targets.get(target);
            }
            if (timedElement3 == null) {
                this.buildElement.element.appendChild(timedElement.element);
            } else {
                timedElement3.element.appendChild(timedElement.element);
            }
            Stack stack = this.getStack();
            if (!stack.empty() && (timedElement2 = (TimedElement)stack.pop()) != timedElement) {
                throw new RuntimeException("Mismatch - popped element = " + timedElement2 + " finished task element = " + timedElement);
            }
        } else {
            throw new RuntimeException("Unknown task " + task + " not in " + this.tasks);
        }
        this.tasks.remove(task);
    }

    private final TimedElement getTaskElement(Task task) {
        TimedElement timedElement = (TimedElement)this.tasks.get(task);
        if (timedElement != null) {
            return timedElement;
        }
        Enumeration enumeration = this.tasks.keys();
        while (enumeration.hasMoreElements()) {
            Task task2 = (Task)enumeration.nextElement();
            if (!(task2 instanceof UnknownElement) || ((UnknownElement)task2).getTask() != task) continue;
            return (TimedElement)this.tasks.get(task2);
        }
        return null;
    }

    public void messageLogged(BuildEvent buildEvent) {
        int n = buildEvent.getPriority();
        if (n > this.msgOutputLevel) {
            return;
        }
        Element element = this.doc.createElement(MESSAGE_TAG);
        String string = "debug";
        switch (buildEvent.getPriority()) {
            case 0: {
                string = ERROR_ATTR;
                break;
            }
            case 1: {
                string = "warn";
                break;
            }
            case 2: {
                string = "info";
                break;
            }
            default: {
                string = "debug";
            }
        }
        element.setAttribute(PRIORITY_ATTR, string);
        CDATASection cDATASection = this.doc.createCDATASection(buildEvent.getMessage());
        element.appendChild(cDATASection);
        TimedElement timedElement = null;
        Task task = buildEvent.getTask();
        Target target = buildEvent.getTarget();
        if (task != null) {
            timedElement = this.getTaskElement(task);
        }
        if (timedElement == null && target != null) {
            timedElement = (TimedElement)this.targets.get(target);
        }
        if (timedElement != null) {
            timedElement.element.appendChild(element);
        } else {
            this.buildElement.element.appendChild(element);
        }
    }

    public void setMessageOutputLevel(int n) {
        this.msgOutputLevel = n;
    }

    public void setOutputPrintStream(PrintStream printStream) {
        this.outStream = new PrintStream(printStream, true);
    }

    public void setEmacsMode(boolean bl) {
    }

    public void setErrorPrintStream(PrintStream printStream) {
    }

    private final /* synthetic */ void this() {
        this.msgOutputLevel = 4;
        this.doc = builder.newDocument();
        this.tasks = new Hashtable();
        this.targets = new Hashtable();
        this.threadStacks = new Hashtable();
        this.buildElement = null;
    }

    public XmlLogger() {
        this.this();
    }

    private static class TimedElement {
        private long startTime;
        private Element element;

        public String toString() {
            return this.element.getTagName() + ':' + this.element.getAttribute(XmlLogger.NAME_ATTR);
        }

        private TimedElement() {
        }
    }
}

